import 'package:photogram_admin_cp/import/core.dart';
import 'package:photogram_admin_cp/import/data.dart';
import 'package:rad/rad.dart';

mixin AppActiveContentInfiniteMixin<T extends StatefulWidget> on State<T> {
  late final AppActiveContent activeContent;

  var latestContentId = 0;
  var bottomContentId = 0;

  var isEndOfResults = false;
  var isLoadingBottom = false;
  var isLoadingLatest = false;

  var isLoadingCallInStack = false;

  /// available for override to widgets

  void onLoadEvent() => 'nop';
  void onDisposeEvent() => 'nop';

  @override
  void initState() {
    activeContent = AppActiveContent(context);
    onLoadEvent();
  }

  @override
  void dispose() {
    onDisposeEvent();
    activeContent.dispose();
  }

  void contentMixinClearState() {
    var isInitialized = true;

    unRegisterLoadingCall();

    try {
      // when active content is not initialized
      // this will throw an exception
      activeContent.context;
    } catch (_) {
      isInitialized = false;
    }

    if (isInitialized) {
      activeContent.clear();
    }

    contentMixinUpdateData(
      setLatestContentId: 0,
      setBottomContentId: 0,
      setLoadingLatest: false,
      setLoadingBottom: false,
      setEndOfResults: false,
      callback: null,
    );
  }

  void contentMixinUpdateData({
    int? setLatestContentId,
    int? setBottomContentId,
    bool? setLoadingBottom,
    bool? setLoadingLatest,
    bool? setEndOfResults,
    Function? callback,
  }) {
    if (null != setLoadingLatest) {
      isLoadingLatest = setLoadingLatest;
    }
    if (null != setLoadingBottom) {
      isLoadingBottom = setLoadingBottom;
    }
    if (null != setEndOfResults) {
      isEndOfResults = setEndOfResults;
    }
    if (null != setLatestContentId) {
      latestContentId = setLatestContentId;
    }
    if (null != setBottomContentId) {
      bottomContentId = setBottomContentId;
    }

    if (null != callback) {
      callback();
    }
  }

  /*
  |--------------------------------------------------------------------------
  | load content:
  |--------------------------------------------------------------------------
  */

  Future<void> contentMixinLoadContent({
    bool latest = false,
    required String latestEndpoint,
    required String bottomEndpoint,
    required Function requestDataGenerator,
    required Function({
      required bool latest,
      required ResponseModel responseModel,
    })? responseHandler,
  }) async {
    if (endOfResults()) return;

    if (!registerLoadingCall()) return;

    procedure() async {
      _startPreloaders(latest: latest);

      var responseModel = await AppProvider.of(context).apiRepo.preparedRequest(
            requestType: latest ? latestEndpoint : bottomEndpoint,
            requestData: Map<String, dynamic>.from(requestDataGenerator()),
          );

      if (responseModel.isNotResponse) {
        //  something went wrong
      } else {
        endOfResults(responseModel.message == END_OF_RESULTS_MSG || responseModel.message == ERROR_BAD_REQUEST_MSG);

        // pass to user defined response handler
        if (null != responseHandler) {
          responseHandler(latest: latest, responseModel: responseModel);
        }
      }

      stopPreloaders(latest: latest);

      unRegisterLoadingCall();
    }

    await procedure();
  }

  /*
  |--------------------------------------------------------------------------
  | preloaders:
  |--------------------------------------------------------------------------
  */

  bool registerLoadingCall() {
    if (isLoadingCallInStack) return false;
    isLoadingCallInStack = true;
    return true;
  }

  bool unRegisterLoadingCall() {
    isLoadingCallInStack = false;
    return true;
  }

  /*
  |--------------------------------------------------------------------------
  | preloaders:
  |--------------------------------------------------------------------------
  */

  bool _startPreloaders({required bool latest}) {
    if (latest) {
      loadingLatest(true);
    } else {
      loadingBottom(true);
    }

    setState(() {});

    return true;
  }

  bool stopPreloaders({required bool latest}) {
    if (latest) {
      loadingLatest(false);
    } else {
      loadingBottom(false);
    }

    setState(() {});

    return true;
  }

  bool loadingLatest([bool? type]) {
    if (null != type) {
      isLoadingLatest = type;
    }
    return isLoadingLatest;
  }

  bool loadingBottom([bool? type]) {
    if (null != type) {
      isLoadingBottom = type;
    }
    return isLoadingBottom;
  }

  bool endOfResults([bool? type]) {
    if (null != type) {
      isEndOfResults = type;
    }
    return isEndOfResults;
  }
}
